#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// multi-scale truchet scaledMod01.fsh  by   phi16
//https://www.shadertoy.com/view/wdjfDK
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float rand(vec2 co, float i){
    return fract(sin(dot(co.xy, vec2(12.9898,78.233))) * 43758.5453 + 0.2 + sqrt(2.) * (i + floor(iTime/2.)));
}

float pattern(vec2 uv, vec2 seed, float seedi) {
    float v = rand(seed, seedi);
    if(v < 0.5) uv.xy = vec2(1.-uv.y,uv.x);
    if(distance(v,0.5) > 0.4) {
        return min(
            distance(distance(uv,vec2(0)),0.5)-1./6.,
            distance(distance(uv,vec2(1)),0.5)-1./6.
        );
    } else if(distance(v,0.5) > 0.1) {
        return min(
            distance(uv.y,0.5)-1./6.,
            max(
                distance(uv.x,0.5)-1./6.,
                - (distance(uv.y,0.5)-1./4.)
            )
        );
    } else {
        uv.y = abs(uv.y-0.5);
        return min(
            abs(uv.y)-1./6.,
            distance(uv,vec2(0.5,0.5))-1./6.
        );
    }
}

int hierarchy(vec2 uv) {
    float u = 1.0;
    for(int i=0;i<5;i++) {
        vec2 iuv = floor(uv*u)/u;
        float s = 1./u;
        if((distance(iuv.y,0.) > s || rand(iuv*u, float(i)) < 0.5) && iuv.y > s/4.) return i;
        u *= 2.;
    }
    return 5;
}

int chierarchy(vec2 uv) {
    float s = 1./64.;
    int h = 0;
    h = max(h, hierarchy(uv + vec2(-s,-s)));
    h = max(h, hierarchy(uv + vec2(+s,-s)));
    h = max(h, hierarchy(uv + vec2(-s,+s)));
    h = max(h, hierarchy(uv + vec2(+s,+s)));
	return h;
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    float ut = fract(iTime/2.);
    float it = floor(iTime/2.);
    
    vec2 uv = fragCoord / iResolution.y;
    vec2 scr = uv;
    uv.y += 0.075;
    uv.x -= iResolution.x / iResolution.y / 2.;
    uv *= 1.8 * pow(2.,-ut);
    
    float d = 0.;
    vec2 luv = fract(uv);
    int h = hierarchy(uv);
    float flip = cos(float(h)*3.1415926535);
    float s = pow(2.,float(h));
    luv = fract(uv*s);
    vec2 seed = floor(uv*s);
   	d = pattern(luv, seed, float(h)) / s * flip;
    s = 1.0;
    for(int i=0;i<6;i++) {
        vec2 corner = floor(uv*s+.5)/s;
        int ch = chierarchy(corner);
        if(h <= i && i < ch) {
            float u = distance(uv, corner)-1./6./s;
            if(i%2 == 0) d = min(d, u);
            else d = max(d, -u);
        }
        s *= 2.;
    }
    d *= mod(it+0.5,2.) < 1.0 ? 1.0 : -1.0;
    d /= pow(2.,-ut) / pow(2.,-scr.y);
    
    vec3 dr = mix(vec3(0.,2.,1.), vec3(1.,0.5,0.), exp(-scr.y)) * exp(min(0.,d)*200.);
    vec3 br = mix(vec3(0.2,0.8,0.), vec3(0.8,0.6,0.2), exp(-scr.y));
    vec3 col = mix(dr,br,smoothstep(-1.,1.,d*iResolution.y*2.));
    fragColor = vec4(clamp(col,vec3(0.),vec3(1.)),1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

